/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.log;

import filenet.vw.api.VWException;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigEventLogNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VWConfigNewEventLogDialog
extends VWModalDialog
implements ActionListener,
KeyListener {
    protected JLabel m_nameLabel = new JLabel();
    protected JTextField m_nameTextField = new JTextField();
    protected JTextArea m_descriptionTextArea = new JTextArea();
    protected JButton m_createButton = new JButton(VWResource.Create);
    protected JButton m_cancelButton = new JButton(VWResource.Cancel);
    protected JButton m_helpButton = new JButton(VWResource.Help);
    private VWConfigBaseNode m_configNode = null;
    private VWConfigEventLogNode m_newLog = null;

    public VWConfigNewEventLogDialog(Frame parent, VWConfigBaseNode configNode) {
        super(parent);
        this.setTitle(VWResource.NewEventLog);
        Dimension dim = VWStringUtils.stringToDimension("445,275");
        if (dim == null) {
            dim = new Dimension(400, 250);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        JPanel subPanel = new JPanel(new BorderLayout());
        subPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel topPanel = this.createTopPanel();
        subPanel.add((Component)topPanel, "First");
        topPanel.getAccessibleContext().setAccessibleParent(subPanel);
        JPanel descripPanel = this.createDescriptionPanel();
        subPanel.add((Component)descripPanel, "Center");
        descripPanel.getAccessibleContext().setAccessibleParent(subPanel);
        JPanel buttonPanel = this.createButtonPanel();
        subPanel.add((Component)buttonPanel, "Last");
        buttonPanel.getAccessibleContext().setAccessibleParent(subPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)subPanel, "Center");
        subPanel.getAccessibleContext().setAccessibleParent(this);
        this.m_configNode = configNode;
        this.setLocationRelativeTo(parent);
    }

    public void releaseResources() {
        if (this.m_nameLabel != null) {
            this.m_nameLabel.removeAll();
            this.m_nameLabel = null;
        }
        if (this.m_nameTextField != null) {
            this.m_nameTextField.removeAll();
            this.m_nameTextField = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        if (this.m_createButton != null) {
            this.m_createButton.removeActionListener(this);
            this.m_createButton.removeAll();
            this.m_createButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.m_configNode = null;
        this.removeAll();
    }

    protected JPanel createTopPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            this.m_nameLabel.setText(VWResource.s_label.toString(VWResource.EventLogName));
            VWAccessibilityHelper.setAccessibility(this.m_nameLabel, mainPanel, VWResource.EventLogName, VWResource.EventLogName);
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 0.0;
            gbConst.insets = new Insets(4, 0, 4, 8);
            mainPanel.add((Component)this.m_nameLabel, gbConst);
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            mainPanel.add((Component)this.m_nameTextField, gbConst);
            this.m_nameTextField.addKeyListener(this);
            this.m_nameTextField.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_nameTextField, mainPanel, VWResource.EventLogName, VWResource.EventLogName);
            VWAccessibilityHelper.setLabelFor(this.m_nameLabel, this.m_nameTextField);
            this.m_nameTextField.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createDescriptionPanel() {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout(4, 4));
            JLabel label = new JLabel(VWResource.s_label.toString(VWResource.Description));
            mainPanel.add((Component)label, "First");
            VWAccessibilityHelper.setAccessibility(label, mainPanel, VWResource.Description, VWResource.Description);
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            mainPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            VWAccessibilityHelper.setAccessibility(this.m_descriptionTextArea, mainPanel, VWResource.Description, VWResource.Description);
            VWAccessibilityHelper.setLabelFor(label, this.m_descriptionTextArea);
            this.m_descriptionTextArea.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            mainPanel.add((Component)this.m_createButton, gbConst);
            mainPanel.add((Component)this.m_cancelButton, gbConst);
            mainPanel.add((Component)this.m_helpButton, gbConst);
            this.m_createButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
            this.setCreateButtonState();
            VWAccessibilityHelper.setAccessibility(this.m_createButton, mainPanel, VWResource.Create, VWResource.Create);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, mainPanel, VWResource.Cancel, VWResource.Cancel);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, mainPanel, VWResource.Help, VWResource.Help);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            this.setVisible(false);
        } else if (obj == this.m_createButton) {
            String nameText = this.m_nameTextField.getText();
            if (nameText == null || nameText.length() == 0) {
                JOptionPane.showMessageDialog(this, VWResource.NameCanNotBeNull, null, 1, null);
            } else if (nameText.startsWith("F_", 0) || nameText.startsWith("f_", 0)) {
                JOptionPane.showMessageDialog(this, VWResource.InvalidConfigName.toString(nameText), VWResource.ErrorMessage, 0);
            } else if (this.createEventLog()) {
                this.setVisible(false);
            }
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc063.htm");
        } else if (obj == this.m_nameTextField) {
            JButton defaultButton = this.getRootPane().getDefaultButton();
            defaultButton.doClick();
        }
    }

    public VWConfigEventLogNode getLogNode() {
        return this.m_newLog;
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        this.setCreateButtonState();
    }

    private void setCreateButtonState() {
        if (this.m_createButton == null) {
            return;
        }
        boolean bEnable = true;
        String tempString = null;
        if (this.m_nameTextField != null) {
            tempString = this.m_nameTextField.getText();
            if (tempString == null || VWStringUtils.compare(tempString, "") == 0) {
                bEnable = false;
            }
        } else {
            bEnable = false;
        }
        if (this.m_createButton.isEnabled() != bEnable) {
            this.m_createButton.setEnabled(bEnable);
        }
        if (this.m_createButton.isEnabled()) {
            this.getRootPane().setDefaultButton(this.m_createButton);
        } else {
            this.getRootPane().setDefaultButton(null);
        }
    }

    private boolean createEventLog() {
        boolean bRet = false;
        try {
            String eName = this.m_nameTextField.getText();
            VWConfigRegionNode regionNode = (VWConfigRegionNode)this.m_configNode;
            VWLogDefinition logDef = regionNode.getSystemConfiguration().createLogDefinition(eName);
            logDef.setDescription(this.m_descriptionTextArea.getText());
            this.m_newLog = new VWConfigEventLogNode(regionNode.getSessionInfo(), logDef, regionNode.getServiceName(), regionNode.getRegionID(), regionNode.getSystemConfiguration());
            bRet = true;
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
        }
        return bRet;
    }
}

